<?php
// اسکریپت برای اصلاح نام API methods در تمام فایل‌های PHP
$files = glob('plugin/*.php');
$replacements = [
    "'editmessagetext'" => "'editMessageText'",
    "'sendmessage'" => "'sendMessage'",
    "'deletemessage'" => "'deleteMessage'",
    "botevoobot('editmessagetext'" => "botevoobot('editMessageText'",
    "botevoobot('sendmessage'" => "botevoobot('sendMessage'",
    "botevoobot('deletemessage'" => "botevoobot('deleteMessage'",
];

foreach($files as $file) {
    $content = file_get_contents($file);
    $original = $content;
    
    foreach($replacements as $old => $new) {
        $content = str_replace($old, $new, $content);
    }
    
    if($content !== $original) {
        file_put_contents($file, $content);
        echo "Fixed: $file\n";
    }
}

echo "Done!\n";
?>
